//////////////////////////////////////////////////////////////////////
//TargetD64 - C64 archive related conversion tool and emulator frontend
//////////////////////////////////////////////////////////////////////
//Copyright (C) 1998, 1999  Karlheinz Langguth klangguth@netscape.net
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//////////////////////////////////////////////////////////////////////

//avoid multiple include of header file
#ifndef _HOST_ARCHIVE_HEADER
#define _HOST_ARCHIVE_HEADER


//concept of a host archive (zip, lha) in opposite to C64 related archives
//this is the class of the top archive (root)
class CFHostArchive : public CFArchive
{
public:
	CFHostArchive() {}
	//P1 I: pathname of archive in host filesystem
	//P2 I: blocksize of archive
	//P3 I: extract command (with placeholders)
	CFHostArchive(const string& path, const int blockSize = 0
		, const string& extractCmd = string(""))
	: CFArchive(path, blockSize, extractCmd) {}

public:
	//call ProcessFilesInArchive() of superclass
	//put final archives into D64 images
	virtual void ProcessFilesInArchive(void) throw (CFException);
};


class CFLhaArchive : public CFHostArchive
{
public:
	//P1 I: pathname of archive in host filesystem
	//P2 I: blocksize of archive
	inline CFLhaArchive(const string& path, const int blockSize = 0)
		: CFHostArchive(path, blockSize, ms_staticExtractCommand) {}

public:
	//checks if P1 is of this archive class
	//P1 I: pathname of archive in host filesystem
	static bool CheckFileIsOfClass(const string& filename);
	//extract the LHA archive into m_workdir
	virtual void Extract(void) throw (CFException);
	//set the extract command (with placeholders)
	//P1 I: extract command (with placeholders)
	inline static void SetExtractCommand(const string &cmd) { ms_staticExtractCommand = cmd; }

private:
	//extract command (with placeholders)
	static string ms_staticExtractCommand;
};


class CFZipArchive : public CFHostArchive
{
public:
	//P1 I: pathname of archive in host filesystem
	//P2 I: blocksize of archive
	inline CFZipArchive(const string& path, const int blockSize = 0)
		: CFHostArchive(path, blockSize, ms_staticExtractCommand) {}

public:
	//checks if P1 is of this archive class
	//P1 I: pathname of archive in host filesystem
	static bool CheckFileIsOfClass(const string& filename);
	//extract the pkzipped archive into m_workdir
	virtual void Extract(void) throw (CFException);
	//set the extract command (with placeholders)
	//P1 I: extract command (with placeholders)
	inline static void SetExtractCommand(const string &cmd) { ms_staticExtractCommand = cmd; }

private:
	//extract command (with placeholders)
	static string ms_staticExtractCommand;
};


class CFGzipArchive : public CFHostArchive
{
public:
	//P1 I: pathname of archive in host filesystem
	//P2 I: blocksize of archive
	inline CFGzipArchive(const string& path, const int blockSize = 0)
		: CFHostArchive(path, blockSize, ms_staticExtractCommand) {}

public:
	//checks if P1 is of this archive class
	//P1 I: pathname of archive in host filesystem
	static bool CheckFileIsOfClass(const string& filename);
	//extract the gnuzipped archive into m_workdir
	virtual void Extract(void) throw (CFException);
	//set the extract command (with placeholders)
	//P1 I: extract command (with placeholders)
	inline static void SetExtractCommand(const string &cmd) { ms_staticExtractCommand = cmd; }

private:
	//extract command (with placeholders)
	static string ms_staticExtractCommand;
};


class CFGenericArchive : public CFHostArchive
{
public:
	//P1 I: pathname of archive in host filesystem
	//P2 I: extract command for the archive
	//P3 I: extension for the archive
	//P4 I: blocksize of archive
	//P2 and P3 are normally static members. For a generic archive
	//they have to be normal members because there can be more than
	//one generic archive (more than one extensions, etc.)
	inline CFGenericArchive(const string& path
		, const string& genericExtractCommand
		, const string& genericExtension
		, const int blockSize = 0)
		: m_extractCommand(genericExtractCommand)
		, m_genericExtension(genericExtension)
		, CFHostArchive(path, blockSize, genericExtractCommand) {}

public:
	//checks if P1 is of this generic archive class
	//P1 I: pathname of archive in host filesystem
	bool CheckFileIsOfClass(const string& filename);
	const string& GetGenericExtractCommand(void) const
	{ return m_extractCommand; }
	const string& GetGenericExtension(void) const
	{ return m_genericExtension; }

private:
	//extract command (with placeholders)
	string m_extractCommand;
	//extension of this generic archive
	string m_genericExtension;

public:
	//vector of all user defined generic archives
	static vector<CFGenericArchive> ms_genericArchives;
};

#endif
