//////////////////////////////////////////////////////////////////////
//TargetD64 - C64 archive related conversion tool and emulator frontend
//////////////////////////////////////////////////////////////////////
//Copyright (C) 1998, 1999  Karlheinz Langguth klangguth@netscape.net
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
//COMPILE SWITCHES
// _MSC_VER
// indicates MS compiler
// _DEBUG
// for debug version which activates ASSERT and TRACE
// TD64_MODIFIED
// marks changes in foreign sources to fit into TargetD64
// must be set everywhere because also used for header files

#include <stdio.h>
#include <string>
#include <vector>
#ifdef _MSC_VER
#include <typeinfo.h>
#include <iostream>
#include <fstream>
#include <strstream>
#else
#include <typeinfo>
#include <iostream.h>
#include <fstream.h>
#include <strstream.h>
#endif

using namespace std;

#include "Tracing.h"
#include "Exception.h"
#include "Image.h"
#include "LynxImage.h"

#include "vdrive.h" //VICE interface


void CFLynxImage::FlushFileIntoFilesystem(const char cname[], const int ftype
	, const int cnt, FILE *stream) throw (CFException)
{
	//put data of the included file into format for vector
	CFExtractedFileInfo newFile;
	newFile.SetFileSize(cnt);
	newFile.SetCbmFilename(CFCbmFilename(string(cname)));
	newFile.SetFileType(ftype);

	//derive filename from CBM filename
	string extractFilename = m_workdir + "/"
		+ newFile.GetCbmFilename().ConvertThisToFilesystemFilename();
	//guarantee unique filename (no overwrite)
	extractFilename = UniqueFileNameGenerator(extractFilename);
	//remember the filename
	newFile.SetFilename(extractFilename);

	ofstream out(extractFilename.c_str(), ios::out | ios::binary);
	if (!out)
	{
		exc = CFException(CFException::FILE_OPEN_FAILED,
			__LINE__, __FILE__, extractFilename, "write from scratch");
		throw exc;
	}
	//loop over the file data
	int ch;
	int i = 0;
	while (i < cnt)
	{
		ch = fgetc(stream);
		if (ch == EOF)
		{
			//even if it is too short give the file a chance
			//there are so many lynx archive out which are a few
			//bytes too short. warning is printed out anyway.
			newFile.SetFileSize(i);
			m_extractedFiles.push_back(newFile);
			exc = CFException(CFException::LYNX_FILE_TOO_SHORT,
				__LINE__, __FILE__, GetFilename(), cname);
			throw exc;
		}
		out.put(ch);
		i++;
	}
	if (!out)
	{
		exc = CFException(CFException::FILE_OPERATION_FAILED,
			__LINE__, __FILE__, extractFilename, "writing");
		throw exc;
	}
	//now that everything worked out fine add the file to vector
	//as extracted
	m_extractedFiles.push_back(newFile);
}


void CFLynxImage::ExtractAllFiles(const string& extractDir) throw (CFException)
{
	ASSERT(extractDir[extractDir.size() - 1] != '/');
	m_workdir = extractDir;

	int ret = FD_OK;
	try {
	ret = unlynx_cmd(*this);
	}
	catch (CFException& exception)
	{
		if (exception.GetExceptionId() == CFException::LYNX_FILE_TOO_SHORT)
		{
			//if lynx file too short go on normal with warning
			exception.WriteOutExceptionWithWarningHeader(cerr);
		}
		else
		{
			//any other error dumps lynx image
			throw;
		}
	}
	if (ret != FD_OK)
	{
		exc = CFException(CFException::LYNX_EXTRACT_FAILED,
			__LINE__, __FILE__, m_filename, "");
		throw exc;
	}
}
