//////////////////////////////////////////////////////////////////////
//TargetD64 - C64 archive related conversion tool and emulator frontend
//////////////////////////////////////////////////////////////////////
//Copyright (C) 1998, 1999  Karlheinz Langguth klangguth@netscape.net
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
//COMPILE SWITCHES
// _MSC_VER
// indicates MS compiler
// _DEBUG
// for debug version which activates ASSERT and TRACE
// TD64_MODIFIED
// marks changes in foreign sources to fit into TargetD64
// must be set everywhere because also used for header files

#ifdef _MSC_VER
#pragma warning(disable:4786) //identifier truncation warning
#endif

#include <vector>
#include <string>
#ifdef _MSC_VER
#include <iostream>
#include <strstream>
#else
#include <iostream.h>
#include <strstream.h>
#endif

using namespace std;

#include "Exception.h"
#include "Image.h"
#include "DiskImage.h"
#include "Archive.h"
#include "MultiPart.h"
#include "Tracing.h"


CFMultiPart::CFMultiPart(const int nPartNum)
	: m_nPartNum(nPartNum)
{
	TRBEGIN("CFMultiPart::CFMultiPart");
	m_aPartAvailFlag = new bool[m_nPartNum];
	m_aPartPathname = new string[m_nPartNum];
	for (int i = 0; i < nPartNum; i++)
		m_aPartAvailFlag[i] = false;
	TRreturn;
}


bool CFMultiPart::SetPartAvailable(const int nPart)
{
	TRBEGIN("CFMultiPart::SetPartAvailable");
	ASSERT(nPart < m_nPartNum);
	TRACE(<< "Part index: " << nPart << " previously available (0=no): " << m_aPartAvailFlag[nPart]);
	bool retVal = m_aPartAvailFlag[nPart];
	m_aPartAvailFlag[nPart] = true;
	TRreturn retVal;
}


void CFMultiPart::SetPartPathname(const int nPart, const string& pathname)
{
	TRBEGIN("CFMultiPart::SetPartPathname");
	ASSERT(nPart < m_nPartNum);
	TRACE(<< "Part index: " << nPart << " pathname: " << pathname);
	m_aPartPathname[nPart] = pathname;
	TRreturn;
}


const string& CFMultiPart::GetPartPathname(const int nPart) const
{
	TRBEGIN("CFMultiPart::GetPartPathname");
	ASSERT(nPart < m_nPartNum);
	TRACE(<< "Part index: " << nPart << " pathname: " << m_aPartPathname[nPart]);
	TRreturn m_aPartPathname[nPart];
}


bool CFMultiPart::TestPartAvailable(const int nPart) const
{
	TRBEGIN("CFMultiPart::TestPartAvailable");
	ASSERT(nPart < m_nPartNum);
	TRACE(<< "Part index: " << nPart << " is (0=not available): " << m_aPartAvailFlag[nPart]);
	TRreturn m_aPartAvailFlag[nPart];
}


bool CFMultiPart::TestCompleteness(void) const
{
	TRBEGIN("CFMultiPart::TestCompleteness");
	for (int i = 0; i < m_nPartNum; i++)
	{
		if (!m_aPartAvailFlag[i])
		{
			TRACE(<< "Incomplete");
			TRreturn false;
		}
	}
	TRACE(<< "Complete");
	TRreturn true;
}

