//////////////////////////////////////////////////////////////////////
//TargetD64 - C64 archive related conversion tool and emulator frontend
//////////////////////////////////////////////////////////////////////
//Copyright (C) 1998, 1999  Karlheinz Langguth klangguth@netscape.net
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//////////////////////////////////////////////////////////////////////

#ifndef _TRACING_HEADER
#define _TRACING_HEADER

#ifdef _DEBUG

//concept of a tracing class
//is derived from ostream as output is made to it
class CTrace : public ostream
{
public:
	//eval environmant variable TRACE to switch trace on/off
	//P1: stream to trace to
	CTrace(streambuf* sb);

public:
	inline ~CTrace() { delete m_attachedFile; m_attachedFile = NULL; }

public:
	//increment nesting level, print margin and BEGIN
	bool TraceBegin(void);
	//print margin and END, decrement nesting level
	bool TraceEnd(void);
	//print margin
	bool TraceMargin(void);
	//switch trace off
	void TraceOff(void);
	//switch tace on
	void TraceOn(void);
	//R: true indicates trace on
	bool TestTraceOn(void) const;
	//P1 I: filename to dump trace into
	void AttachTraceDumpToFile(const string& filename);

private:
	//nesting level of methods/function
	//increased by TRBEGIN and decreased by TRreturn
	int m_nesting;
	bool m_bActive; //true indicates TRACE active
	ostream *m_attachedFile;
};


//globale trace object which manages trace
extern CTrace _glbTrace;

//test condition, if false terminate program
#define ASSERT(a) \
if (!(a)) \
{ \
	cerr << "Assertion failed in File " << __FILE__ << " Line " << __LINE__ <<endl; \
	exit(1); \
}
//use _MyTraceTest to assure that we have at least a TRBEGIN
#define TRACE(a) if (_MyTraceTest, _glbTrace.TraceMargin()) _glbTrace a << endl
#define TRBEGIN(a) bool _MyTraceTest; if (_glbTrace.TraceBegin()) _glbTrace << a << endl
#ifdef _MSC_VER
//problem is, that _glbTrace.TraceEnd() and the following return has to be
//one statement. if-Statement does not work, because compiler reports error
//that there is no return in each case of control flow
#define TRreturn for (_glbTrace.TraceEnd(); true; _MyTraceTest) return 
#else
#define TRreturn if (_glbTrace.TraceEnd(), _MyTraceTest, true) return
#endif

#define TRACEON _glbTrace.TraceOn()
#define TRACEOFF _glbTrace.TraceOff()
#define TRACEATTACHFILE(a) _glbTrace.AttachTraceDumpToFile(a)
#define TESTTRACEON _glbTrace.TestTraceOn()

#else

#define ASSERT(a)
#define TRACE(a)
#define TRBEGIN(a)
#define TRreturn return
#define TRACEON
#define TRACEOFF
#define TRACEATTACHFILE(a)
#define TESTTRACEON 0

#endif

#endif
