/*----------------------------------------------------------------------*/
/*			LHarc Extract Command				*/
/*		This is part of LHarc UNIX Archiver Driver		*/
/*									*/
/*		Copyright(C) MCMLXXXIX  Yooichi.Tagawa			*/
/*									*/
/*  V0.00  Original				1988.05.23  Y.Tagawa	*/
/*  V1.00  Fixed				1989.09.22  Y.Tagawa	*/
/*  V0.03  LHa for UNIX				1991.12.17  M.Oki	*/
/*----------------------------------------------------------------------*/

#include "lharc.h"
#include "intrface.h"

extern int decode_lzhuf ();

#ifdef TD64_MODIFIED
static char *writting_filename;
static char *reading_filename;
#endif

#ifndef TD64_MODIFIED
static boolean
inquire_extract (name)
char *name;
{
  struct stat stbuf;

  if (stat (name, &stbuf) >= 0)
    {
      if (!is_regularfile (&stbuf))
	{
	  error ("Already exist (not a file)", name);
	  return FALSE;
	}

      if (noexec)
	{
	  printf ("EXTRACT %s but file is exist.\n", name);
	  return FALSE;
	}
      else if (!force)
	{
	  if (!isatty(0)) return FALSE;
	  switch (inquire ("OverWrite ?(Yes/No/All)", name, "YyNnAa"))
	    {
	    case 0:
	    case 1:		/* Y/y */
	      break;
	    case 2:
	    case 3:		/* N/n */
	      return FALSE;
	    case 4:
	    case 5:		/* A/a */
	      force = TRUE;
	      break;
	    }
	}
    }

  if (noexec)
    printf ("EXTRACT %s\n", name);

  return TRUE;
}
#endif

#ifndef TD64_MODIFIED
static boolean
make_parent_path (name)
char *name;
{
  char path[FILENAME_LENGTH];
  struct stat stbuf;
  register char *p;

  /* make parent directory name into PATH for recursive call */
  strcpy (path, name);
  for (p = path + strlen (path); p > path; p--)
    if (p[-1] == '/')
      {
	*--p = '\0';
	break;
      }

  if (p == path)
    {
      message ("Why?", "ROOT");
      return FALSE;			/* no more parent. */
    }

  if (stat (path, &stbuf) >= 0)
    {
      if (is_directory (&stbuf))
	return TRUE;
      error ("Not a directory", path);
      return FALSE;
    }
  errno = 0;

  if (verbose)
    printf ("Making directory \"%s\".", path);

  if (mkdir (path, 0777) >= 0)/* try */
    return TRUE;			/* successful done. */
  errno = 0;

  if (!make_parent_path (path))
    return FALSE;

  if (mkdir (path, 0777) < 0)	/* try again */
    {
      message ("Cannot make directory", path);
      return FALSE;
    }

  return TRUE;
}

static FILE *
open_with_make_path (name)
char *name;
{
  FILE *fp;

  if ((fp = fopen (name, WRITE_BINARY)) == NULL)
    {
#ifndef TD64_MODIFIED
      errno = 0;
      if (!make_parent_path (name) ||
	  (fp = fopen (name, WRITE_BINARY)) == NULL)
#endif
	  error ("Cannot extract", name);
      errno = 0;
    }
  return fp;
}


static void
adjust_info (name,hdr)
char *name;
LzHeader *hdr;
{
  time_t utimebuf[2];

  /* adjust file stamp */
  utimebuf[0] = utimebuf[1] = hdr->unix_last_modified_stamp;
  utime (name, utimebuf);

  if (hdr->extend_type == EXTEND_UNIX
      || hdr->extend_type == EXTEND_OS68K
      || hdr->extend_type == EXTEND_XOSK)
	{
#ifdef NOT_COMPATIBLE_MODE
	  Please need your modification in this space.
#else
	  chmod (name, hdr->unix_mode);
#endif
#ifndef TD64_MODIFIED
	  if(!getuid())
	    chown (name, hdr->unix_uid, hdr->unix_gid);
#endif
	  errno = 0;
	}
}
#endif

static char *methods[10] =
{
	"-lh0-", "-lh1-", "-lh2-", "-lh3-", "-lh4-",
	"-lh5-", "-lzs-", "-lz5-", "-lz4-", NULL
};


#ifdef TD64_MODIFIED
static void MakeUniqueFilename(char name[])
{
	char newName[257];
	char infix[4] = "000";
	struct stat stbuf;
	int trial = 0;

	int extensionIdx = strlen(name);
	if (stat(name, &stbuf) >= 0)
    {
		/*file is already there*/
		char *lastSlash = strrchr(name, '/');
		char *lastDot = strrchr(name, '.');
		if (lastDot > lastSlash)
		{
			//we have found an extension - this has to be kept!
			extensionIdx = lastDot - name;
		}
		do
		{
			//increment the infix
			if (infix[2] == '9')
			{
				infix[2] = '0';
				if (infix[1] == '9')
				{
					infix[1] = '0';
					infix[0]++;
				}
				else
					infix[1]++;
			}
			else 
				infix[2]++;

			//now build up the new filename
			strcpy(newName, name);
			//end it at extension
			newName[extensionIdx] = '\0';
			//add the infix
			strcat(newName, infix);
			//add the extension
			strcat(newName, &(name[extensionIdx]));
		}
		while ((stat(newName, &stbuf) >= 0) && (trial++ < 200));
		//if loop terminated successfully take over the name
		if (trial < 200)
			strcpy(name, newName);
	}
}
#endif

static void
extract_one (afp, hdr)
FILE *afp;					/* archive file */
LzHeader *hdr;
{
  FILE *fp;					/* output file */
  char name[257];
  int crc;
  int method;
#ifndef TD64_MODIFIED
  boolean save_quiet, save_verbose;
#endif
  char *q = hdr->name , c;

#ifdef TD64_MODIFIED
  if (rindex(hdr->name,'/'))
#else
  if ( ignore_directory && rindex(hdr->name,'/') )
#endif
    {
      q = (char *)rindex(hdr->name,'/') + 1;
    }
  else
    {
      if ( *q=='/' )
	{
	  q++;
	  /*
	   *	if OSK then strip device name
	   */
	  if (hdr->extend_type == EXTEND_OS68K
	      || hdr->extend_type == EXTEND_XOSK )
		{
		  do c=(*q++); while ( c && c!='/' );
		  if ( !c || !*q ) q = ".";	/* if device name only */
		}
	}
    }

  if (extract_directory)
    sprintf (name, "%s/%s", extract_directory, q);
  else
    strcpy (name, q);

  if ((hdr->unix_mode & UNIX_FILE_TYPEMASK) == UNIX_FILE_REGULAR)
    {
      for (method = 0; ; method++)
	{
	  if (methods[method] == NULL)
	    {
#ifdef TD64_MODIFIED
  	      fatal_error ("Compression method not implemented");
#else
	      error ("Unknown method skiped ...", name);
#endif
	      return;
	    }
	  if (bcmp (hdr->method, methods[method], 5) == 0)
	    break;
	}

      reading_filename = archive_name;
      writting_filename = name;
#ifndef TD64_MODIFIED
      if (output_to_stdout || verify_mode)
	{
	  if (noexec)
	    {
	      printf ("%s %s\n", verify_mode ? "VERIFY" : "EXTRACT",name);
	      if (afp == stdin)
		{
		  int i = hdr->packed_size;
		  while(i--) fgetc(afp);
		}
	      return;
	    }

	  save_quiet = quiet;
	  save_verbose = verbose;
	  if (!quiet && output_to_stdout)
	    {
	      printf ("::::::::\n%s\n::::::::\n", name);
	      quiet = TRUE;
	      verbose = FALSE;
	    }
	  else if (verify_mode)
	    {
	      quiet = FALSE;
	      verbose = TRUE;
	    }

	  crc = decode_lzhuf
	    (afp, stdout, hdr->original_size, hdr->packed_size, name, method);
	  quiet = save_quiet;
	  verbose = save_verbose;
	}
      else
#endif
	{
#ifndef TD64_MODIFIED
	  if (!inquire_extract (name))
	    return;
#endif

#ifndef TD64_MODIFIED
	  if (noexec)
	    {
	      if (afp == stdin)
		{
		  int i = hdr->packed_size;
		  while(i--) fgetc(afp);
		}
	      return;
	    }

	  signal (SIGINT, interrupt);
	  signal (SIGHUP, interrupt);

	  unlink (name);
	  errno = 0;
#endif

#ifndef TD64_MODIFIED
	  remove_extracting_file_when_interrupt = TRUE;
	  if ((fp = open_with_make_path (name)) != NULL)
	    {
	      crc = decode_lzhuf
		(afp, fp, hdr->original_size, hdr->packed_size, name, method);
	      fclose (fp);
	    }
	  remove_extracting_file_when_interrupt = FALSE;
	  signal (SIGINT, SIG_DFL);
	  signal (SIGHUP, SIG_DFL);
	  if (!fp)
	    return;
#else
	  /*make the filename unique so no file is lost while extracting*/
      MakeUniqueFilename(name);
      if ((fp = fopen (name, WRITE_BINARY)) != NULL)
	  {
	      crc = decode_lzhuf
		(afp, fp, hdr->original_size, hdr->packed_size, name, method);
	      fclose (fp);
	    }
		else
		{
			fatal_error("Open of file to extract failed");
		}
#endif
	}

      errno = 0;
      if (hdr->has_crc && crc != hdr->crc)
#ifdef TD64_MODIFIED
  	      fatal_error ("CRC checksum error - file corrupted");
#else
	error ("CRC error", name);
#endif

    }
  else if ((hdr->unix_mode & UNIX_FILE_TYPEMASK) == UNIX_FILE_DIRECTORY)
    {
#ifndef TD64_MODIFIED
      if (!ignore_directory && !verify_mode)
	{
	  if (noexec)
	    {
	      printf ("EXTRACT %s (directory)\n", name);
	      return;
	    }
	  /* NAME has trailing SLASH '/', (^_^) */
	  if (!output_to_stdout && !make_parent_path (name))
	    return;
	}
#endif
    }
  else
    {
#ifdef TD64_MODIFIED
  	      fatal_error ("Invalid file type information in lha header");
#else
      error ("Unknown information", name);
#endif
    }

#ifndef TD64_MODIFIED
  if (!output_to_stdout)
    adjust_info (name,hdr);
#endif
}

/*----------------------------------------------------------------------*/
/*			EXTRACT COMMAND MAIN				*/
/*----------------------------------------------------------------------*/

void
cmd_extract ()
{
  LzHeader hdr;
  long pos;
  FILE *afp;

#ifdef TD64_MODIFIED
  make_crctable();
#endif

  /* open archive file */
  if ((afp = fopen (archive_name, READ_BINARY)) == NULL)
    fatal_error ("Open of input file failed");
  if (archive_is_msdos_sfx1 (archive_name))
    skip_msdos_sfx1_code (afp);

  /* extract each files */
  while (get_header (afp, &hdr))
    {
#ifdef TD64_MODIFIED
	  pos = ftell (afp);
	  extract_one (afp, &hdr);
	  fseek (afp, pos + hdr.packed_size, SEEK_SET);
#else
      if (need_file (hdr.name))
	{
	  pos = ftell (afp);
	  extract_one (afp, &hdr);
	  fseek (afp, pos + hdr.packed_size, SEEK_SET);
	}
      else
	{
	  if (afp != stdin)
	    fseek (afp, hdr.packed_size, SEEK_CUR);
	  else
	    {
	      int i = hdr.packed_size;
	      while(i--) fgetc(afp);
	    }
	}
#endif
    }

  /* close archive file */
  fclose (afp);

  return;
}
