/*
 * zipcode.c - Support for zipcode files in VICE.
 *
 * Written by
 *  Daniel Sladic (sladic@eecg.toronto.edu)
 *
 * modifications done to this source by
 * Karlheinz Langguth (klangguth@netscape.net)
 * to fit into TargetD64 (copyleft by GPL).
 * All changes marked by TD64_MODIFIED compile
 * switch.
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#ifdef TD64_MODIFIED

#include <stdio.h>
#ifdef _MSC_VER
#include <io.h>
#else
#include <unistd.h>
#endif
#else

#include "vice.h"

#ifdef STDC_HEADERS
#include <stdio.h>
#ifdef __riscos
#include "types.h"
#else
#include <unistd.h>
#endif
#endif

#endif

#include "zipcode.h"

#ifdef TD64_MODIFIED
#define SAVE_BUFFER_WRITE \
{ \
	if (count >= 256) \
		return 1; \
	buf[count++] = chra; \
}
#endif

int zipcode_read_sector(file_desc_t zip_fd, int track, int *sector, char *buf)
{
  unsigned char trk, sec, len, rep, repnum, chra;
  int i, j, count, t1, t2;

  t1 = read(zip_fd, &trk, 1);
  t2 = read(zip_fd, &sec, 1);

  *sector = sec;

  if ((trk & 0x3f) != track || !t1 || !t2) {
    return 1;
  }

  if (trk & 0x80) {
    t1 = read(zip_fd, &len, 1);
    t2 = read(zip_fd, &rep, 1);
    if (!t1 || !t2) {
       return 1;
    }

    count = 0;

    for (i = 0; i < len; i++) {
      if ( (t1 = read(zip_fd, &chra, 1)) == 0) {
         return 1;
      }

      if (chra != rep)
#ifdef TD64_MODIFIED
		SAVE_BUFFER_WRITE
#else
	buf[count++] = chra;
#endif
      else {
        t1 = read(zip_fd, &repnum, 1);
        t2 = read(zip_fd, &chra, 1);
        if (!t1 || !t2) {
           return 1;
        }
	i += 2;
	for (j = 0; j < repnum; j++)
#ifdef TD64_MODIFIED
		SAVE_BUFFER_WRITE
#else
	  buf[count++] = chra;
#endif
      }
    }
  }

  else if (trk & 0x40) {
    if ( (t1 = read(zip_fd, &chra, 1)) == 0) {
       return 1;
    }

    for (i = 0; i < 256; i++)
      buf[i] = chra;
  }

  else if (256 != read (zip_fd, buf, 256)) {
    return 1;
  }

  return 0;
}
