/*
 * Copyright (C) 1998, 1999 Wolfgang Moser
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Commodore CBM 1581 floppy disk copy util for PC's, FDCLOWLV.H
 *
 * Redirected contact addresses:
 *   Wolfgang Moser <womo@mindless.com>
 *   Wolfgang Moser <womo@fairlight.to>
 *    http://www.dollar8000.de/womo
 *
 * Current workplace (up to Dezember 1999):
 *   Wolfgang Moser <womo@advm2.gm.fh-koeln.de>
 *    http://advm2.gm.fh-koeln.de/~womo
 *
 *
 * Basic informations from Dan Fandrich <dan@fch.wimsey.bc.ca>.
 *   His readme of the cbmfs-0.3 driver for Linux explained me, what the
 *   difference between a DOS formatted 800 kb disk and a CBM 1581 disk is.
 *   (check: http://vanbc.wimsey.com/~danf/software/)
 *
 *
 * Basic implementations by Ciriaco Garca de Celis <ciri@gui.uva.es>
 *   His util 765Debug, Version 5.0 is great for learning dma based
 *   direct floppy disk controller programming.
 *   (check: ftp://ftp.gui.uva.es/pub/pc/2m/765d50sr.zip)
 *
 * Check out for his floppy disk utils 2M and 2MGUI, the last words
 * in improving floppy disk storage capacity.
 *   http://www.gui.uva.es/2m, ftp://ftp.gui.uva.es/pub/pc/2m
 *
 *
 * For additional informations to FDC programming check:
 *     http://developer.intel.com/design/periphrl/datashts/290468.htm
 *   and get the intel 82078 CHMOS Single-Chip Floppy Disk Controller
 *   PDF document:
 *     http://www.intel.nl/design/periphrl/datashts/29047403.pdf
 *   National Semiconductor has also some pages about their PC
 *   compatible controllers:
 *     http://www.national.com/pf/DP/DP8473.html
 *     http://www.national.com/pf/DP/DP8477B.html
 *
 * Another good source for floppy disk controller programming information
 * are the linux kernal sources, you could have a look into:
 *     http://www.cs.utexas.edu/users/peterson/linux/include/linux/fdreg.h
 *     http://www.cs.utexas.edu/users/peterson/linux/drivers/block/floppy.c
 *
 * Now, that I started talking about Linux: Check out the most massive
 * attack against floppy disks ever made, Alain Knaff's fdutils:
 *     http://fdutils.linux.lu/
 *     http://alain.knaff.linux.lu/
 */

#ifndef __FDC_Low_Level__
#define __FDC_Low_Level__

#include "central.h"
#include <stdio.h>
#include <dos.h>

	// !!!
	// Don't optimize the code to `fastest'!!!
	// !!!


	// floppy disk controller NEC PD765 compatible registers

#define FD_DATA	0x3F5	// FDC PD765 data IO register
#define FD_STATUS	0x3F4	// FDC PD765 main status register
#define FD_DOR		0x3F2	// FDC PD765 digital output register
#define FD_DCR		0x3F7	// digital input / floppy control register


	// timer tick based timeout values

#define FDC_TIMEOUT	8	// ca.  440 ms ( 8/18.2 s)
#define OP_TIMEOUT	37	// ca. 2000 ms (37/18.2 s)
// #define OP_TIMEOUT	8

/* later: #ifdef DJGPP
   #define huge
   #include <sys/movedata.h>
   unsigned char peekb(unsigned long Segment, unsigned short Offset);
   void pokeb(unsigned long Segment, unsigned short Offset, unsigned char Value);
#endif
*/

	// some typedefs for reducing too much text
typedef	unsigned int	uint;
typedef	unsigned char	uint8;
typedef	unsigned short	uint16;
typedef	unsigned long	uint32;

typedef struct{
	uint8 Cylinders;	// assume that doublestepping (40 cyl.) is not needed
	uint8 Heads;		// assume that disk sides are always swapped
	uint8 Sectors;		// assume that the first sector number is always 1
	uint8 BpS;			// 0->128, 1->256, 2->512, 3->1024, ...

	uint8 Bitrate;		// the bitrate
   uint8 Modulation;	// MFM or FM modulation
	uint8 SpecifyCMD;	// the step rate and head unload time

	uint8 RWGAP3;		// the read/write GAP 3
	uint8 FmtGAP;		// the "real" GAP 3 size, when a track is formatted
   uint8 Pattern;		// the format bit pattern
	}FDCparameterSet;

extern FDCparameterSet FDprm;		// global variable in the implementation

typedef	union{
	struct{
		short	ST0;		// valid values: 0...255, -1 (FDC not responding)
		uint8	ST1;
		uint8	ST2;

		uint8	Cylinder;
		uint8	Side;		// physically, not Commodore logically
		uint8	Sector;
		uint8	BytesPS;	// bytes per sector description (divided by 256)
		}D;
	uint8 Status[8];		// the whole status word
	}resultString;

	// prototypes

#ifdef USE_TSC
unsigned long int read_tsc(void);
unsigned long int diff_TSC(unsigned long int lastTSC, unsigned long int newTSC);
#endif

/* unexported functions? */
int	waitUntilReady4Transfer	(uint8 *);
void	clearFDCresults			(void);
int	outFDC						(uint8 data);
int	inFDC							(void);

void	prepareDMA					(uint8 mode, uint16 bytes,
										 uint8 huge *DMAbuf);
void	waitUntilInterrupt		(int timeout);

void	switchMotorOn				(uint8 drive);
void	switchMotorOff				(void);
void	specifyDensity				(void);
void	selectDrive					(uint8 drive);
int	senseInterruptStat		(resultString *resStr);
void	resetDrive					(uint8 drive);
int	valid7ResultString		(resultString *resStr);
/* */
void	printResultString			(resultString *resStr);

resultString *recalibrateDrive(uint8 drive, uint8 side);
resultString *seekToCyl			(uint8 drive, uint8 cyl, uint8 side);

int			  senseDiskStatus	(uint8 drive);

int 			  readSectorID		(uint8 drive, uint8 side,
										 resultString *header, int timeout);

resultString *formatCBMtrack	(uint8 drive,  uint8 cyl, uint8 side);
resultString *readCBMsector	(uint8 drive,  uint8 cyl, uint8 side,
										 uint8 sector, uint8 sideID, uint8 huge *buffer);
resultString *writeCBMsector	(uint8 drive,  uint8 cyl, uint8 side,
										 uint8 sector, uint8 sideID, uint8 huge *buffer);
resultString *verifyCBMsector	(uint8 drive,  uint8 cyl, uint8 side,
										 uint8 sector, uint8 sideID, uint8 huge *buffer);

resultString *readCBMtrack		(uint8 drive,  uint8 cyl, uint8 side,
										 uint8 sector, uint8 sideID, uint8 huge *buffer);
resultString *writeCBMtrack	(uint8 drive,  uint8 cyl, uint8 side,
										 uint8 sector, uint8 sideID, uint8 huge *buffer);
resultString *verifyCBMtrack	(uint8 drive,  uint8 cyl, uint8 side,
										 uint8 sector, uint8 sideID, uint8 huge *buffer);
#ifdef FDCintel82078
	// intel 82078 FDC extended commands
short			  check4intelFDC	(void);
resultString *fnwriteCBMtrack	(uint8 drive,	uint8 cyl, uint8 side,
										 uint8 huge *buffer);
#endif
#endif
