/*
 * Copyright (C) 1998, 1999 Wolfgang Moser
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Commodore CBM 1581 floppy disk copy util for PC's, FRMHEADR.H
 *
 * Redirected contact addresses:
 *   Wolfgang Moser <womo@mindless.com>
 *   Wolfgang Moser <womo@fairlight.to>
 *    http://www.dollar8000.de/womo
 *
 * Current workplace (up to Dezember 1999):
 *   Wolfgang Moser <womo@advm2.gm.fh-koeln.de>
 *    http://advm2.gm.fh-koeln.de/~womo
 *
 *
 * Basic informations from Dan Fandrich <dan@fch.wimsey.bc.ca>.
 *   His readme of the cbmfs-0.3 driver for Linux explained me, what the
 *   difference between a DOS formatted 800 kb disk and a CBM 1581 disk is.
 *   (check: http://vanbc.wimsey.com/~danf/software/)
 *
 *
 * Basic implementations by Ciriaco Garca de Celis <ciri@gui.uva.es>
 *   His util 765Debug, Version 5.0 is great for learning dma based
 *   direct floppy disk controller programming.
 *   (check: ftp://ftp.gui.uva.es/pub/pc/2m/765d50sr.zip)
 *
 * Check out for his floppy disk utils 2M and 2MGUI, the last words
 * in improving floppy disk storage capacity.
 *   http://www.gui.uva.es/2m, ftp://ftp.gui.uva.es/pub/pc/2m
 *
 *
 * For additional informations to FDC programming check:
 *     http://developer.intel.com/design/periphrl/datashts/290468.htm
 *   and get the intel 82078 CHMOS Single-Chip Floppy Disk Controller
 *   PDF document:
 *     http://www.intel.nl/design/periphrl/datashts/29047403.pdf
 *   National Semiconductor has also some pages about their PC
 *   compatible controllers:
 *     http://www.national.com/pf/DP/DP8473.html
 *     http://www.national.com/pf/DP/DP8477B.html
 *
 * Another good source for floppy disk controller programming information
 * are the linux kernal sources, you could have a look into:
 *     http://www.cs.utexas.edu/users/peterson/linux/include/linux/fdreg.h
 *     http://www.cs.utexas.edu/users/peterson/linux/drivers/block/floppy.c
 *
 * Now, that I started talking about Linux: Check out the most massive
 * attack against floppy disks ever made, Alain Knaff's fdutils:
 *     http://fdutils.linux.lu/
 *     http://alain.knaff.linux.lu/
 */

#ifndef __Format_Headers__
#define __Format_Headers__
/* later: #ifdef DJGPP
   #define huge
#endif
*/

void		FD2000createBAM(unsigned char huge *buffer);
void		FD2000createSYS(unsigned char huge *buffer);
void		C1581createBAM	(unsigned char huge *buffer);

#endif
