/***************************************************************************
 * trans64.h          version 2.1                                          *
 *                                                                         *
 * Lowlevelroutines for transfer 1541-PC                                   *
 *                                                                         *
 * Copyright (C) 1994/95  Bernhard Schwall                                 *
 *                                                                         *
 * This file is distributed WITHOUT ANY WARRANTY; without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.        *
 ***************************************************************************/

#ifndef _TRANS64_H
#define _TRANS64_H

typedef unsigned char byte;

#ifdef __cplusplus
extern "C" {
#endif

#define CableDISK64E 0
#define CableX1541   1

/* wait (len*256)/1.193 s */
void WaitHI(byte len);

/* wait len/1.193 s */
void WaitLO(byte len);

/* turn keyboard on and off */
void Keyboard(byte on);

/* the following routines are named as in the C64 */

/* IECopen device 'Geraet', Secondarry address 'SekAdr', text 'Text'        */
void IECopen(byte Geraet, byte *SekAdr, char *Text);

/* Clear Channel */
void CLRCH(void);

/* */
void Talk(byte Value);

/* */
void Listen(byte Value);

/* */
void SekTalk(byte Value);

/* */
void Seklist(byte Value);

/* */
void Unlisten(void);

/* */
void Untalk(void);

/* set Data to 0,1 */
void Data(byte Value);

/* set Clock to 0,1 */
void Clock(byte Value);

/* set ATN to 0,1 */
void ATN(byte Value);

/* */
void IECout(byte Value);

/* */
void ByteOut(byte Value);

/* */
byte IECin(void);

/* see IECopen */
void Open64(byte Kanal, byte Geraet, byte *SekAdr, char *Text);

/* close LogFileNumber 'Kanal' */
void Close64(byte Kanal);

/* get values of an open channel */
byte GetFileTab(byte Kanal, byte *Geraet, byte *SekAdr);

/* get one byte from LogFileNumber 'Kanal' */
byte Get64(byte Kanal);

/* read a maximum of count bytes from 'Kanal' to text, return number of */
/* read byte */
unsigned int GetBlock64(byte Kanal, byte *text, unsigned int count);

/* print the 'text' to LogFileNumber 'Kanal' ($FFD2) */
void Print64(byte Kanal, byte *text, unsigned int count);

/* read the errormessage form device 'Geraet' and store it into 'text' */
void Message64(byte Geraet, char *Text);

/* send the command 'text' to device 'Geraet' */
void SendCommand(byte Geraet, char *text);

/* get the value of the error-variable */
/* possible results are                */
/*  0 = no error                       */
/*  1 = wrong device number            */
/*  2 = missing name                   */
/*  3 = timeout                        */
/*  4 = wrong second address           */
/*  5 = device not present             */
/*  6 = missing log. file number       */
/*  7 = file open                      */
/*  8 = too many files open            */
/*  9 = <unused>                       */
/* 10 = timeout (output)               */
/* 11 = timeout (input)                */
/* 12 = file not open                  */
/* 64 = end of file                    */
byte Error(void);

/* set the error-variable to 'Value' */
void SetError(byte Value);

/* get the setup for the Cable */
void GetCableValues(byte *aWA, byte *aWC, byte *aWD, unsigned int *aPortAdr);

/* get the timeout value */
unsigned long GetTimeOut(void);

/* initialize the routines, set transferport to LPT 'PortNr'   */
/* if PortNr > 4 then PortNr is the baseaddress of the port    */
/* Cable == 0 => DISK64E cable, Cable == 1 => X1541 Cable      */
/* returns the portaddress (read form the BIOS if PortNr <= 4) */
int Init64(int PortNr, byte Cable);

#ifdef __cplusplus
}
#endif

#endif
