//////////////////////////////////////////////////////////////////////
//TargetD64 - C64 archive related conversion tool and emulator frontend
//////////////////////////////////////////////////////////////////////
//Copyright (C) 1998, 1999  Karlheinz Langguth klangguth@netscape.net
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//////////////////////////////////////////////////////////////////////

//avoid multiple include of header file
#ifndef _FRONTEND_EXCEPTION_HEADER
#define _FRONTEND_EXCEPTION_HEADER

const string INVALID("InVaLiD"); //value for an invalid parameter string


//prints out textual form of exception P2 on P1
//P1 IO: stram to print to
//P2 I: exception to print out
class CFException;
ostream& operator<<(ostream& ostr, const CFException& exc);


class CFException
{
public:
//prints out textual form of exception P2 on P1
//P1 IO: stram to print to
//P2 I: exception to print out
friend ostream& operator<<(ostream& ostr, const CFException& exc);

public:
	//all exceptions
	typedef enum
	{
		EXCEPTION_INVALID
		,FILE_OPEN_FAILED
		,CHANGE_DIRECTORY_FAILED
		,GET_CURRENT_DIRECTORY_FAILED
		,OPEN_DIRECTORY_FAILED
		,FILE_STAT_FAILED
		,UNEXPECTED_FILE_TYPE
		,FILE_OPERATION_FAILED
		,CLOSE_DIRECTORY_FAILED
		,SYSTEM_CALL_FAILED
		,FILE_RENAME_FAILED
		,INCOMPLETE_MULTI_PART_ARCHIVE
		,UNIQUE_NAME_CREATION_FAILED
		,CREATE_DIRECTORY_FAILED
		,FILE_REMOVAL_FAILED
		,FILE_TOO_BIG_FOR_D64
		,MULTIPLE_PART_OF_MULTIPART_ARCHIVE
#ifdef _MSC_VER
		,MEMORY_ALLOCATION_FAILED
		,FILENAME_CONVERSION_LONG_SHORT_FAILED
#endif
		,DISK_IMAGE_SIZE_INCORRECT
		,DISK_IMAGE_HAS_CIRCULAR_LINKAGE
		,DISK_IMAGE_DIRECTORY_CORRUPTED
		,DISK_IMAGE_FILETYPE_NOT_SUPPORTED
		,DISK_FILE_LINK_ERROR
		,UNIQUE_FILENAME_GENERATION_ERROR
		,DISK_FILE_LAST_BLOCK_SIZE_ERROR
		,DISK_DIRECTORY_ALLOC_ERROR
		,DISK_CONTROL_BLOCK_DIRECTORY_LINK_ERROR
		,DISK_CONTROL_BLOCK_ALLOC_ERROR
		,DISK_BAM_FREE_COUNT_ERROR
		,DISK_DIRECTORY_FULL_ERROR
		,FILE_ZERO_LENGTH_ERROR
		,FILE_DOES_NOT_FIT_ON_DISK
		,FILE_DUP_FAILED
		,FILE_DUP2_FAILED
		,TAPE_IMAGE_TOO_SMALL
		,TAPE_IMAGE_NOT_ENOUGH_ENTRIES
		,TAPE_FILE_OFFSET_OUT_OF_BOUND_ERROR
		,TAPE_FILE_OFFSETS_ERROR
		,TAPE_FILE_CORRUPTED
		,TAPE_IMAGE_UNKNOWN_FILE_TYPE
		,ARCHIVE_EMPTY
		,APPLICATION_ERROR
		,GENERIC_EXTENSION_MISSING_ERROR
		,C64ZIP_EXTRACT_FAILED
		,LYNX_EXTRACT_FAILED
		,LYNX_FILE_TOO_SHORT
		,GZIP_EXTRACT_FAILED
		,PKZIP_EXTRACT_FAILED
		,LHA_EXTRACT_FAILED
		,EMULATOR_CALL_FAILED
		,PROFILE_ERROR
	} tException;

	//exception list entry (unites exception ID and message text)
	typedef struct
	{
		tException id;
		char *message;
	} tExceptionList;

public:
	//P1 I: exception ID
	//P2 I: line number in source of exception statement
	//P3 I: filename of source where exception is raised
	//P4 I: param1 string
	//P5 I: param2 string
	//P6 I: OS error (errno) if valid
	CFException(const tException nException = EXCEPTION_INVALID,
	 	const int nLineno = -1, const string& filename = INVALID,
		const string& param1 = INVALID, const string& param2 = INVALID,
		const int nSystemError = -1);

public:
	//R: exception ID
	inline tException GetExceptionId(void) const
		{ return static_cast<tException>(m_nException); }
	//P1 I: value of param1 to set
	inline void SetParam1(const string& param1)
		{ m_param1 = param1; }
	//print out a warning header with exception info on P1
	//P1 IO: stream to print to
	void WriteOutExceptionWithWarningHeader(ostream &out) const;
	//print out an error header with exception info on P1
	//P1 IO: stream to print to
	void WriteOutExceptionWithErrorHeader(ostream &out) const;

private:
	int m_nException; //exception ID
	int m_nLinenumber; //line number where exception generated
	string m_filename; //file where exception generated
	string m_param1; //additional info to exception
	string m_param2; //see above
	int m_nSystemError; //error number of OS, if valid
	//warning level of exception. if greater than ms_nMaxWarningLevel
	//exceptions are not printed out
	//warning level 0 is reserved for silent mode (no exception ever printed)
	int m_nWarningLevel;

public:
	//convert an int to a string (used for param1/2 strings)
	inline static string IntToString(const int nNum)
	{
		strstream ret;
		ret << nNum << '\0';
		return ret.str();
	}
	//Set the maximum warning level for exceptions to be printed out
	//P1 I: warning level to set
	//0 means no exception message is printed out (silence mode)
	inline static void SetMaxWarningLevel(int nLevel)
	{ ms_nMaxWarningLevel = nLevel; }
private:
	static tExceptionList excTable[]; //messages for all exceptions
	static bool m_bIntegrityChecked; //true if already checked
	//maximum warning level to be printed out
	//exceptions with warning levels greater than this are not printed.
	static int ms_nMaxWarningLevel;
};

extern CFException exc; //global exception

#endif
