//////////////////////////////////////////////////////////////////////
//TargetD64 - C64 archive related conversion tool and emulator frontend
//////////////////////////////////////////////////////////////////////
//Copyright (C) 1998, 1999  Karlheinz Langguth klangguth@netscape.net
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//////////////////////////////////////////////////////////////////////

#ifndef _MULTI_PART_HEADER
#define _MULTI_PART_HEADER

//abstract concept of a multipart archive
//ATTENTION: this has to be superclass of any multipart archive
class CFMultiPart
{
public:
	//alloc flags for each part and set each to false (no avail)
	//P1 I: number of parts in archive (e.g. 4 for [1-4]!)
	CFMultiPart(const unsigned int nPartNum);
	inline ~CFMultiPart(void)
	{
		delete [] m_aPartAvailFlag;
		delete [] m_aPartPathname;
	}

public:
	//set part P1 to available
	//P1 I: index of part to be set to avail
	//R: previous state of part P1, true means available
	bool SetPartAvailable(const unsigned int nPart);
	//set the pathname of part P1
	//P1 I: index of part to set pathname
	//P2 I: pathname
	void SetPartPathname(const unsigned int nPart, const string& pathname);
	//get the pathname of part P1
	//P1 I: index of part to set pathname
	const string& GetPartPathname(const unsigned int nPart) const;
	//test part P1 for avail
	//P1 I: index of part to be set to avail
	//R: state of part P1, true means available
	bool TestPartAvailable(const unsigned int nPartNum) const;
	//test if all parts of archive are available
	//R: true means all parts available
	bool TestCompleteness(void) const;
	//R: number of expected parts in archive
	inline unsigned int GetPartNum(void) const { return m_nPartNum; }
	//check if P1 belongs to this multipart
	//if so assimilate it
	//P1 I: candidate to be tested
	//R: true if belongs
	virtual bool CheckBelongingAndMergeIfBelongs(const CFArchive& archive) = 0;

private:
	//just to make sure those operators are not used
	inline CFMultiPart(const CFMultiPart&);
	inline CFMultiPart& operator=(const CFMultiPart& a);

protected:
	//array of pathnames of all participated files
	bool *m_aPartAvailFlag; //pointer to array of availability flag for each part
	//array of pathnames of all participated files
	//is needed to collect parts when spread over multiple directories
	string *m_aPartPathname;
	unsigned int m_nPartNum; //number of expected parts for a completed archive
};

#endif

