//////////////////////////////////////////////////////////////////////
//TargetD64 - C64 archive related conversion tool and emulator frontend
//////////////////////////////////////////////////////////////////////
//Copyright (C) 1998, 1999  Karlheinz Langguth klangguth@netscape.net
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//////////////////////////////////////////////////////////////////////

//avoid multiple include of header file
#ifndef _OPTIONS_HEADER
#define _OPTIONS_HEADER

//use this option string for option key
//whenever you want to access arguments that are not tied to a option
const string OP_STD_ARG("StDaRg"); 

class CFOptions
{
public:
	typedef void (*tHandler) (const string&);
	class CFRegisteredOption
	{
	friend CFOptions;
	public:
		CFRegisteredOption(bool bArg = false, tHandler pFct = NULL)
			: m_bArgumentFollows(bArg)
			, m_pHandlerFct(pFct) {}
	private:
		bool m_bArgumentFollows; //argument follows option?
		tHandler m_pHandlerFct; //handler for option
	};
	//key is option character
	//if value is true: argument follows option (else standalone)
	typedef map<string, CFRegisteredOption> tRegisteredOption;
	//key is option character
	//value is argument following option (only if possible)
	typedef multimap<string, string> tParsedOption;
	//type of callback registering
	typedef enum
	{
		CB_UNKNOWN_OPTION
	} tCallbackEnum;

public:
	CFOptions()
		: m_pUnknownOptionCallback(NULL) {}

public:
	//parse the command line
	//look for options and actualize database.
	//call HandleUnknownOption if option is not registered
	//call HandleStandardArg if no option but command
	//line string encountered. after "--" do not search for options.
	//if parameters have default values arguments come from m_arg, m_argv
	//P1 I: number of command line arguments
	//P2 I: array of command line arguments, index 0 for prog name
	void ParseCommandLine(int argc, char *argv[]);
	//register a callback function
	//P1 I: type of callback
	//R: true if succeeded
	bool RegisterCallback(tCallbackEnum t, tHandler p);
	//register an expected command line option
	//P1 I: expected option string
	//P2 I: true means arg follows (-f <filename> for example)
	//P3 I: handler function to call whenever option is encountered
	//R: true if succeeded
	bool RegisterOption(const string& opt, bool bArg, tHandler p = NULL);
	//query the parsed options for a particular option P1
	//return all arguments (if option has been stated more than once)
	//P1 I: option string
	//P2 O: vector of arguments associated with option
	bool QueryOption(const string& opt, vector<string>& args) const;
	//query the parsed options for a particular option P1
	//return the LAST argument used with option
	//P1 I: option string
	//P2 O: argument associated with LAST occurrence of option
	bool QueryOption(const string& opt, string& arg) const;

	//Set this object as application wide option server
	inline void SetAppOptions() { s_pAppOptions = this; }

public:
	//Get pointer to the application wide object server
	inline static const CFOptions* GetAppOptions(void) { return s_pAppOptions; }


private:
	//called when not registered option encountered.
	//P1 I: unexpected option string encountered
	void HandleUnknownOption(const string& opt) const;
	//called when registered option encountered.
	//when callback is registered it will be called
	//P1 I: iterator to entry found registered option map
	//P2 I: argument string following the option (may be empty)
	void HandleKnownOption(const tRegisteredOption::const_iterator& i, const string& arg);

private:
	tHandler m_pUnknownOptionCallback;
	tRegisteredOption m_registeredOptions;
	tParsedOption m_parsedOptions;

private:
	static CFOptions* s_pAppOptions; //pointer to option object that is application wide server
};

#endif
